/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.lib.sentry.config;

import dev.tr7zw.lib.sentry.SystemOutLogger;
import dev.tr7zw.lib.sentry.config.ClasspathPropertiesLoader;
import dev.tr7zw.lib.sentry.config.CompositePropertiesProvider;
import dev.tr7zw.lib.sentry.config.EnvironmentVariablePropertiesProvider;
import dev.tr7zw.lib.sentry.config.FilesystemPropertiesLoader;
import dev.tr7zw.lib.sentry.config.PropertiesProvider;
import dev.tr7zw.lib.sentry.config.SimplePropertiesProvider;
import dev.tr7zw.lib.sentry.config.SystemPropertyPropertiesProvider;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PropertiesProviderFactory {
    @NotNull
    public static PropertiesProvider create() {
        Properties runDirectoryProperties;
        Properties properties;
        String environmentVariablesLocation;
        Properties properties2;
        SystemOutLogger logger = new SystemOutLogger();
        ArrayList<PropertiesProvider> providers = new ArrayList<PropertiesProvider>();
        providers.add(new SystemPropertyPropertiesProvider());
        providers.add(new EnvironmentVariablePropertiesProvider());
        String systemPropertyLocation = System.getProperty("sentry.properties.file");
        if (systemPropertyLocation != null && (properties2 = new FilesystemPropertiesLoader(systemPropertyLocation, logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(properties2));
        }
        if ((environmentVariablesLocation = System.getenv("SENTRY_PROPERTIES_FILE")) != null && (properties = new FilesystemPropertiesLoader(environmentVariablesLocation, logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(properties));
        }
        if ((properties = new ClasspathPropertiesLoader(logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(properties));
        }
        if ((runDirectoryProperties = new FilesystemPropertiesLoader("sentry.properties", logger).load()) != null) {
            providers.add(new SimplePropertiesProvider(runDirectoryProperties));
        }
        return new CompositePropertiesProvider(providers);
    }
}

